DECLARE SUB warte (Zeit!)
REM Basic-Beispiel zum Programmieren der seriellen Schnittstelle
REM des Anzeigers Typ 9180 mit RS 232 oder Option RS485 interface
REM burster praezisionsmesstechnik QSI/AG 01.03.2000                     

REM Typ 9180 Geraete-Parametrierung (Siehe auch BA Seite Abs. 4.3.6ff)
REM Menue 51(Soft)=Prot-1, 52(bAUd)=9600, 53(AdrS)= 1(-x) (1,2,3 bis 10)
REM Menue 54(trAnS)=1,   (55(dLY)= 1 bis 5 und nur bei RS 485 verfgbar)            
REM Bei RS 232 Betrieb sollte AdrS(Adresse) = 1 eingestellt sein

REM Einstellungen am RS 485 Schnittstellenkonverter (Option):
REM -----  IC 485 S =  SW2           SW1                 ------
REM -----           T-RTS/Rx on      DCE                 ------

REM Kabelbelegung:          REM  RS485   <   PC    >  RS232
REM Konverter IC485S    (Adapter 9po)  PC Buchse 9polig   RS 232 Kabel
REM           3(TxD) ----- (2(TxD)) -----< 2(RxD) >-----  braun (TxD) 2
REM           2(RxD) ----- (3(RxD)) -----< 3(TxD) >-----  weiss (RxD) 3
REM           4(CTS) ----- (7(RTS)) -----< 7(RTS) >-----
REM           5(RTS) ----- (8(CTS)) -----< 8(CTS) >-----  gruen (unten)1
REM           7(GND) ----- (5(GND)) -----< 5(GND) >-----  rot  (oben) 4

DIM a$(30):        REM Messwert$ (bzw. Auslesewert)
cr$ = CHR$(13):    REM Ende Zeichen definieren
CLS :              REM  Bildschirm loeschen
OPEN "COM1:9600, n, 8, 1, cs, ds, " FOR RANDOM AS #1

Start: PRINT :     REM Zeilenvorschub
Highadr$ = "0":    REM Hoeherwertiges Adressbyte Grunddefinition
Lowadr$ = "0":     REM Niederwertiges Adressbyte
Befehl$ = "D":     REM Grunddefinition Messwert einholen
Befehl1$ = "":     REM Grunddefinition fuer Aenderungsbefehle (Werte)
In$ = "":          REM Befehl - Eingabe- String

INPUT "Befehl ausgeben = B,  Geraete einlesen = E,  Enter = Ende "; In$
 SELECT CASE In$
        CASE "B"
          GOSUB Befehlausgeben
        CASE "E"
          GOSUB Einlesen
        CASE ""
          GOTO ende
 END SELECT
GOTO Start:        REM Schleife naechster Eingabezyklus

Einlesen:
 INPUT "Was moechten Sie einlesen?  D=Messwerte, V=Minwerte P=Maxwerte T=Tara (Ther)"; Befehl$
  IF Befehl$ <> "D" AND Befehl$ <> "V" AND Befehl$ <> "P" AND Befehl$ <> "T" THEN
   Befehl$ = "D"
  END IF

 INPUT "An wieviel Geraete Adressen (1-9) moechten Sie einlesen"; Anzahl$
  IF Anzahl$ < "1" OR Anzahl$ > "9" THEN Anzahl$ = "1"
  
 INPUT "Wieviel Zyklen (1 - 100) moechten Sie einlesen"; Schleife
  IF Schleife < 1 OR Schleife > 100 THEN Schleife = 1
 
 FOR Zyklen = 1 TO Schleife:           REM Anzahl der Messzyklen
  FOR Anzmess = 1 TO VAL(Anzahl$):     REM Anzahl der Adressen abfragen
   Lowadr$ = RIGHT$(STR$(Anzmess), 1): REM Stinglaenge auf 1 Ziffer begrenzen

GOSUB Ausgabe:                         REM Befehl ausgeben
GOSUB Dathol:                          REM Antwort einlesen
  
   PRINT "Zyklus="; Zyklen; " Adresse= "; Anzmess; " Messwert= "; Einlese$;
  NEXT
 NEXT
RETURN

Befehlausgeben:
INPUT "Welche Geraete-Adresse von 0-9 moechten Sie stimulieren"; Lowadr$
  IF Lowadr$ < "0" OR Lowadr$ > "9" THEN Lowadr$ = "1"
ein2:
Befehl$ = "": Befehl1$ = ""
PRINT : PRINT "Welchen Ditel-Befehl moechten Sie ausgeben ?"
PRINT "v  = Befehl Loeschen des Min-Speichers"
PRINT "p  = Befehl Loeschen des Max-Speichers"
PRINT "r  = Befehl Loeschen des Tara-Speichers"
PRINT "t  = Befehl Uebernahme Displaywert als Tara"
PRINT "M1 = Befehl Uebertragung des Schaltpunktes 1 (Option)"
PRINT "M2 = Befehl Uebertragung des Schaltpunktes 2 (Option)"
PRINT "M3 = Befehl Uebertragung des Schaltpunktes 3 (Option)"
PRINT "M4 = Befehl Uebertragung des Schaltpunktes 4 (Option)"
PRINT
 INPUT "Befehl v, p, r, oder t bzw. M1, M2, M3, M4,"; Befehl$
 IF Befehl$ <> "v" AND Befehl$ <> "p" AND Befehl$ <> "r" AND Befehl$ <> "t" AND Befehl$ <> "M1" AND Befehl$ <> "M2" AND Befehl$ <> "M3" AND Befehl$ <> "M4" THEN
   PRINT : PRINT "Bitte geben Sie einen Befehl z.B. t (Tara-Wert uebernehmen) ein"
   GOTO ein2: REM (Falsche) Befehlseingabe wiederholen
END IF

IF Befehl$ = "v" OR Befehl$ = "p" OR Befehl$ = "r" OR Befehl$ = "t" THEN
   GOSUB Ausgabe:
 ELSE
   IF Befehl$ = "M1" OR Befehl$ = "M2" OR Befehl$ = "M3" OR Befehl$ = "M4" THEN
    INPUT "Wert (Beispiel + oder -0.2345) moechten Sie waehlen"; Befehl1$
    GOSUB Ausgabe
   END IF
END IF

Ausgabe:
   Ausgabe$ = "*" + Highadr$ + Lowadr$ + Befehl$ + Befehl1$ + cr$
   
   OUT &H3FC, INP(&H3FC) OR &H2:      REM RTS auf high setzen (senden 485)
   PRINT #1, Ausgabe$; :              REM Befehl ausgeben
  
   WHILE (INP(&H3FD) AND &H60) <> &H60: REM Line-Status-Register 5 (F8+5)
                                        REM Warten bis Sendepuffer leer
   WEND: REM H20=Transmitter-Holding-register empty H40=Transmitter empty
 
   OUT &H3FC, INP(&H3FC) AND &HFD:    REM RTS auf low setzen (Empfang 485)
                                      REM Modem-Control-Register 4 (F8+4)
RETURN

Dathol:
  warte (.1):      REM  ca 0.1s bis 0.3s warten auf Schnittstelle !
                   REM bei delay = 1 = 30ms (BA Seite 4-45)
   c$ = "": Einlese$ = "":            REM alte Werte loeschen
     WHILE c$ <> cr$:                 REM einlesen bis Ende-Zeichen
      c$ = INPUT$(1, #1):             REM 1 Zeichen abholen
      Einlese$ = Einlese$ + c$:       REM zusammensetzen
     WEND
   
 IF Einlese$ = Ausgabe$ OR LEFT$(Einlese$, 1) = "*" THEN
   IF Befehl$ = "V" OR Befehl$ = "P" OR Befehl$ = "D" OR Befehl$ = "T" OR Befehl$ = "L1" OR Befehl$ = "L2" OR Befehl$ = "L3" OR Befehl$ = "L4" THEN
      GOTO Dathol:     REM Einlesewert war Spiegelung von RS485 Schnittstelle
   END IF:             REM Wir muessen Werte nocheinmal einholen
 END IF
RETURN

ende:
  CLOSE #1:                           REM RS232 Close
END

SUB warte (Zeit) :
    ende = TIMER + Zeit
    DO
    LOOP UNTIL TIMER > ende
END SUB

